package ch.frankel.blog.validation;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.util.Set;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;

import org.junit.Before;
import org.junit.Test;

import ch.frankel.blog.validation.model.Person;


public class SimpleValidationTest {

	private Validator validator;

	@Before
	public void setUp() throws Exception {

		validator = Validation.buildDefaultValidatorFactory().getValidator();
	}

	/**
	 * Tests the {@link NotNull} annotation. Checks there's a unique violation
	 * on the <code>firstName</code> property.
	 */
	@Test
	public void validatePersonNullName() {

		Person person = new Person();

		Set<ConstraintViolation<Person>> violations = validator
				.validate(person);

		assertFalse(violations.isEmpty());
		assertEquals(1, violations.size());

		ConstraintViolation<Person> violation = violations.iterator().next();

		assertEquals("firstName", violation.getPropertyPath().iterator().next()
				.getName());
	}

	@Test
	public void validatePersonNotNullName() {

		Person person = new Person();

		person.setFirstName("jo");

		Set<ConstraintViolation<Person>> violations = validator
				.validate(person);

		assertTrue(violations.isEmpty());
	}
}
